 <!DOCTYPE html>

 <html <?php language_attributes();?>>

    <head>

        <?php if(get_field("site_favicon","options")): ?>

            <link rel="icon" type="image/png" href="<?php the_field("site_favicon","options"); ?>" />

        <?php endif; ?>

        <title><?php bloginfo('name'); ?> <?php wp_title(); ?></title>

        <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />		

		<script>

            var template_directory = "<?php echo get_template_directory_uri(); ?>";

            var ajax_url = "<?php echo admin_url('admin-ajax.php'); ?>";

            var postId = "<?php if(isset($post->ID)) {echo $post->ID; }?>";	

			var currentpage = <?php if(is_single($post)){echo "true";}else{echo "false";}?>;			

        </script>  

        <style>

			<?php

			if(get_field('background_image','options'))

			{

				echo 'body{';

				echo 'background-image: url("'.get_field('background_image','options').'") !important;';

				echo '}';

			}

			if(get_field('background_color','options'))

			{

				echo '#background-gradient{';

				echo 'background-color:'.get_field('background_color','options').' !important;';

				echo '}';

			}
			
			

			?>

        </style>

		<?php register_custom_fonts();?>

		<?php wp_head(); ?>

    </head>

    <body <?php body_class(); ?>>

	<style>

		<?php 
			set_font_style();
			set_logo_dimensioins();
		?>

    </style>

	<?php

		if(get_field('custom_css','options'))

		{

		  the_field('custom_css','options');

		}

	  

		if(get_field('custom_javascript','options'))

		{

			the_field('custom_javascript','options');

		}  

	?>

      <div id="background-gradient"></div>

	  <div id="header">

		<div class="container">

			<div class="logo-container">

                <div class="center-logo">				

                <?php $logo = get_field('logo','options');?>

                <?php if($logo):?>

                    <?php $image = wp_get_attachment_image_src($logo,'full'); ?>

                    <a href="<?php echo get_site_url(); ?>" class="logo"><img src = "<?php echo $image[0];?>"/></a>

                <?php elseif (get_field('text_logo','options')): ?>

                    <?php $font = get_field('text_logo_font','options');?>

                    <a href="<?php echo get_site_url(); ?>"  class="logo" style="width: auto; color:<?php the_field('text_logo_color','options'); ?>!important; font-family: <?php echo $font['family']; ?>; font-size: <?php the_field('text_font_size','options'); ?>px; " class="titleLogo"><?php the_field('text_logo','options');?></a>

                <?php else:?>

                    <a href="<?php echo get_site_url(); ?>" class="logo"><?php bloginfo('name');?></a>

                <?php endif;?>

                </div>				

			</div>

			<div class="search-logo-container">

                <div class="center-search">

				    <i class="icon-search pull-right"></i>

                </div>

			</div>

            <div class="show-nav">

                <a class="" href="#"><i class="icon-reorder pull-right"></i></a>

            </div>

            <div class="main-menu"><!--menu starts here-->

                <?php wp_nav_menu(array( 'theme_location' => 'primary', 'container_class' => 'menu-menu-container'));?>

            </div><!--menu ends here-->

		</div><!--.container-->

        <div class="search-bar-container">

            <div id="search-bar">

                <div class="container">

                    <div class="close-search"><i class="icon-remove search-icon"></i></div>

					<form role="search" method="get" id="searchform" class="searchform" action="<?php bloginfo('url'); ?>">

						<div>			

							<input type="text" value="" name="s" id="search-field" placeholder="type something to search">

							<input type="submit" style="visibility:hidden;" id="searchsubmit" value="Search">

						</div>

					</form>

                </div>

            </div>

        </div>

    </div><!--#header-->

	<div class="loading-container">

		<p class="loading">

			<i class="icon-spinner icon-spin icon-3x"></i>

			<!--<span class="title">Loading...</span>-->

		</p>

	</div>            